<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Delivery extends Model 
{

    protected $table = 'deliveries';
    public $timestamps = true;
    protected $fillable = array('seller_id', 'user_name', 'email', 'max_commission');

    public function favoriteSellers()
    {
        return $this->belongsToMany('App\Models\Seller');
    }

    public function pendingOrders()
    {
        return $this->belongsToMany('App\Models\Order');
    }

    public function acceptedOrders()
    {
        return $this->hasMany('App\Models\Order');
    }

    public function appCommissions()
    {
        return $this->morphMany('App\Models\ApplicationCommission');
    }

    public function reviews()
    {
        return $this->morphMany('App\Models\Review');
    }

    public function contacts()
    {
        return $this->morphMany('App\Models\Contact');
    }

}